/*======================================================================================
                             POST FXAA RENDERING PASSES
======================================================================================*/

#define s0 lumaSampler
#define width BUFFER_WIDTH
#define height BUFFER_HEIGHT
#define px BUFFER_RCP_WIDTH
#define py BUFFER_RCP_HEIGHT
#define dx ((AverageBlur * 0.05)*px)
#define dy ((AverageBlur * 0.05)*py)

/*------------------------------------------------------------------------------
						FILTER TO USE CHECK
------------------------------------------------------------------------------*/
#if (USE_PRE_SHARPEN == 1)
#include "enb\Shaders\PreSharpen.h"
#endif
#if (USE_HDR == 1)
#include "enb\Shaders\HDR.h"
#endif
#if (USE_BLOOM == 1)
#include "enb\Shaders\Bloom.h"
#endif
#if (USE_TECHNICOLOR == 1)
#include "enb\Shaders\Technicolor.h"
#endif
#if (USE_TONEMAP == 1)
#include "enb\Shaders\Tonemap.h"
#endif
#if (USE_SEPIA == 1)
#include "enb\Shaders\Sepia.h"
#endif
#if (USE_VIGNETTE == 1)
#include "enb\Shaders\Vignette.h"
#endif
#if (USE_ANAGLYPH == 1)
#include "enb\Shaders\Anaglyph.h"
#endif
#if (USE_POST_SHARPEN == 1)
#include "enb\Shaders\PostSharpen.h"
#endif
#if (USE_FINAL_LIMITER == 1)
#include "enb\Shaders\FinalLimiter.h"
#endif


/*------------------------------------------------------------------------------
						RENDERING PASSES
------------------------------------------------------------------------------*/

float4 main( float2 tex)
{
	// PreSharpenPass (has to be the first pass because it samples multiple texels)
	#if (USE_PRE_SHARPEN == 1)
		float4 pass1 = SharpenPass(tex);
	#else
		float4 pass1 = tex2D(s0,tex);
	#endif
	// HDRPass
	#if (USE_HDR == 1)
		float4 pass2 = HDRPass(pass1,tex);
	#else
		float4 pass2 = pass1;
	#endif
	// BloomPass
	#if (USE_BLOOM == 1)
		float4 pass3 = BloomPass (pass2,tex);
	#else
		float4 pass3 = pass2;
	#endif
	// Technicolor
	#if (USE_TECHNICOLOR == 1)
		float4 pass4 = TechnicolorPass( pass3, tex);
	#else
		float4 pass4 = pass3;
	#endif
	// TonemapPass
	#if (USE_TONEMAP == 1)
		float4 pass5 = TonemapPass( pass4, tex);
	#else
		float4 pass5 = pass4;
	#endif
	// SepiaPass
	#if (USE_SEPIA == 1)
		float4 pass6 = SepiaPass (pass5,tex);
	#else
		float4 pass6 = pass5;
	#endif
	//VignettePass
	#if (USE_VIGNETTE == 1)
		float4 pass7 = VignettePass( pass6, tex);
	#else
		float4 pass7 = pass6;
	#endif
	// AnaglyphPass
	#if (USE_ANAGLYPH == 1)
		float4 pass8 = AnaglyphPass(pass7,tex);
	#else
		float4 pass8 = pass7;
	#endif
	// PostSharpenPass
	#if (USE_POST_SHARPEN == 1)
		float4 pass9 = PostSharpenPass (pass8,tex);
	#else
		float4 pass9 = pass8;
	#endif
	// FinalLimiterPass (always last)
	#if (USE_FINAL_LIMITER == 1)
		float4 pass10 = limiter (pass9,tex);
	#else
		float4 pass10 = pass9;
	#endif
	// ReturnFinalColor
	return pass10;
}